package cx.threeg.dcms.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpClient {
    private String ua = "Mozilla/5.0 (Linux; Android 7.0; DCMS) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36";

    public String get(String url) throws Exception {
        HttpURLConnection c = (HttpURLConnection) new URL(url).openConnection();
        c.setRequestProperty("User-Agent", ua);
        c.setConnectTimeout(10000); c.setReadTimeout(15000);
        c.setInstanceFollowRedirects(true);

        InputStream in = new BufferedInputStream(c.getInputStream());
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        br.close(); in.close();
        return sb.toString();
    }

    public byte[] getBytes(String url) throws Exception {
        HttpURLConnection c = (HttpURLConnection) new URL(url).openConnection();
        c.setRequestProperty("User-Agent", ua);
        c.setConnectTimeout(10000); c.setReadTimeout(15000);
        InputStream in = new BufferedInputStream(c.getInputStream());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096]; int n;
        while ((n = in.read(buf)) != -1) { bos.write(buf, 0, n); }
        in.close(); return bos.toByteArray();
    }
}
